/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.MemItem;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;

class MemAllocSimulator {
    private int lmbSize;
    private long totalFreeLMB;
    private LinkedList freeList = new LinkedList();
    private long availPageTableSpace;
    CIMOMHandle cimHandle;
    CIMObjectPath cecObjPath;
    String cecName;
    String cspVersion;
    int pageTableRatio;

    public MemAllocSimulator(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string, String string2, int n, long l, int n2) {
        this.cimHandle = cIMOMHandle;
        this.cecObjPath = cIMObjectPath;
        this.cecName = string;
        this.cspVersion = string2;
        this.lmbSize = n;
        this.totalFreeLMB = l / (long)this.lmbSize + (long)(l % (long)this.lmbSize > 0L ? 1 : 0);
        this.pageTableRatio = n2;
        MemItem memItem = new MemItem(1L, this.totalFreeLMB);
        this.freeList.add(memItem);
        this.availPageTableSpace = 0L;
    }

    public boolean allocContiguousMemory(int n, int n2) {
        System.out.println("MemAllocSimulator: Total free memory = " + this.totalFreeLMB + "LMBs");
        System.out.println("MemAllocSimulator: Allocating contiguous memory = " + n + "LMBs at boundary " + n2);
        if (this.totalFreeLMB < (long)n) {
            return false;
        }
        ListIterator<MemItem> listIterator = this.freeList.listIterator(0);
        while (listIterator.hasNext()) {
            MemItem memItem = (MemItem)listIterator.next();
            long l = memItem.startAddr + memItem.numOfLMB;
            long l2 = memItem.startAddr % (long)n2;
            long l3 = l2 == 0L ? memItem.startAddr : memItem.startAddr + (long)n2 - memItem.startAddr % (long)n2;
            long l4 = memItem.numOfLMB - (l3 - memItem.startAddr);
            if (l4 < (long)n) continue;
            System.out.println("MemAllocSimulator: Allocated LMB_ID=" + l3 + " NUM_OF_LMB=" + n);
            if (memItem.startAddr == l3) {
                if ((long)n == memItem.numOfLMB) {
                    listIterator.remove();
                } else {
                    memItem.startAddr += (long)n;
                    memItem.numOfLMB -= (long)n;
                    listIterator.set(memItem);
                }
            } else {
                memItem.numOfLMB = l3 - memItem.startAddr;
                listIterator.set(memItem);
                long l5 = l3 + (long)n;
                if (l5 < l) {
                    MemItem memItem2 = new MemItem(l5, l - l5);
                    listIterator.add(memItem2);
                    System.out.println("MemAllocSimulator: new MemItem start=" + l5 + ", size=" + (l - l5));
                }
            }
            this.totalFreeLMB -= (long)n;
            return true;
        }
        return false;
    }

    public boolean allocMemory(int n) {
        System.out.println("MemAllocSimulator: Total free memory = " + this.totalFreeLMB + "LMBs");
        if (this.totalFreeLMB < (long)n) {
            return false;
        }
        int n2 = n;
        ListIterator<MemItem> listIterator = this.freeList.listIterator(0);
        while (listIterator.hasNext() && n2 > 0) {
            MemItem memItem = (MemItem)listIterator.next();
            if ((long)n2 >= memItem.numOfLMB) {
                System.out.println("MemAllocSimulator: Allocated LMB_ID=" + memItem.startAddr + " NUM_OF_LMB=" + memItem.numOfLMB);
                this.totalFreeLMB -= memItem.numOfLMB;
                n2 = (int)((long)n2 - memItem.numOfLMB);
                listIterator.remove();
                continue;
            }
            System.out.println("MemAllocSimulator: Allocated LMB_ID=" + memItem.startAddr + " NUM_OF_LMB=" + n2);
            this.totalFreeLMB -= (long)n2;
            memItem.numOfLMB -= (long)n2;
            memItem.startAddr += (long)n2;
            n2 = 0;
            listIterator.set(memItem);
        }
        return n2 == 0;
    }

    public boolean profileAllocMemoryV2(Vector vector) {
        int n = ((UnsignedInt32)((CIMProperty)vector.elementAt(7)).getValue().getValue()).intValue();
        int n2 = n / this.lmbSize + (n % this.lmbSize > 0 ? 1 : 0);
        System.out.println("MemAllocSimulator: Required Memory = " + n2 + " LMBs");
        int n3 = ((UnsignedInt32)((CIMProperty)vector.elementAt(6)).getValue().getValue()).intValue();
        int n4 = n3 / this.lmbSize + (n3 % this.lmbSize > 0 ? 1 : 0);
        System.out.println("MemAllocSimulator: Desired Memory = " + n4 + " LMBs");
        int n5 = 4;
        n5 = n4 >= 4 && n4 <= 64 ? 4 : 64;
        System.out.println("MemAllocSimulator: allocating RMO memory ...");
        boolean bl = this.allocContiguousMemory(n5, n5);
        if (!bl) {
            System.out.println("MemAllocSimulator: allocating RMO memory failed");
            return false;
        }
        int n6 = n4 * this.lmbSize / this.pageTableRatio;
        int n7 = n6 / this.lmbSize;
        int n8 = n6 % this.lmbSize;
        System.out.println("MemAllocSimulator: allocating pagetable memory ...");
        if (n7 > 0) {
            if (n8 > 0) {
                ++n7;
            }
            if (!(bl = this.allocContiguousMemory(n7, n7))) {
                System.out.println("MemAllocSimulator: allocating pagetable memory failed");
                return false;
            }
        } else if (n8 > 0) {
            if (this.availPageTableSpace >= (long)n8) {
                this.availPageTableSpace -= (long)n8;
            } else {
                bl = this.allocContiguousMemory(1, 1);
                if (!bl) {
                    System.out.println("MemAllocSimulator: allocating pagetable memory failed");
                    return false;
                }
                if (this.availPageTableSpace == 0L) {
                    this.availPageTableSpace = this.lmbSize - n8;
                }
            }
        }
        System.out.println("MemAllocSimulator: allocating the rest of memory");
        bl = this.allocMemory(n4 - n5);
        if (!bl && !(bl = this.allocMemory(n2 - n5))) {
            System.out.println("MemAllocSimulator: allocating memory failed");
            return false;
        }
        System.out.println("MemAllocSimulator: Memory allocation succeeded.");
        return true;
    }

    public boolean profileAllocMemoryV3(Vector vector) {
        int n = ((UnsignedInt32)((CIMProperty)vector.elementAt(10)).getValue().getValue()).intValue();
        int n2 = n / this.lmbSize + (n % this.lmbSize > 0 ? 1 : 0);
        System.out.println("MemAllocSimulator: Required Memory = " + n2 + " LMBs");
        int n3 = ((UnsignedInt32)((CIMProperty)vector.elementAt(9)).getValue().getValue()).intValue();
        int n4 = n3 / this.lmbSize + (n3 % this.lmbSize > 0 ? 1 : 0);
        System.out.println("MemAllocSimulator: Desired Memory = " + n4 + " LMBs");
        int n5 = ((UnsignedInt32)((CIMProperty)vector.elementAt(11)).getValue().getValue()).intValue();
        int n6 = n5 / this.lmbSize + (n5 % this.lmbSize > 0 ? 1 : 0);
        System.out.println("MemAllocSimulator: Maximum Memory = " + n6 + " LMBs");
        short s = ((UnsignedInt8)((CIMProperty)vector.elementAt(4)).getValue().getValue()).shortValue();
        System.out.println("MemAllocSimulator: RMO Type = " + s);
        int n7 = 1;
        if (s == 1) {
            if (n4 >= 1 && n4 <= 16) {
                n7 = 1;
            } else if (n4 >= 4 && n4 <= 64) {
                n7 = 4;
            } else if (n4 >= 65 && n4 <= 1024) {
                n7 = 64;
            } else if (n4 > 1024) {
                n7 = 1024;
            }
        } else {
            n7 = 1;
        }
        boolean bl = this.allocContiguousMemory(n7, n7);
        if (!bl) {
            return false;
        }
        int n8 = n6 * this.lmbSize / this.pageTableRatio;
        int n9 = n8 / this.lmbSize + (n8 % this.lmbSize > 0 ? 1 : 0);
        bl = this.allocContiguousMemory(n9, n9);
        if (!bl) {
            return false;
        }
        System.out.println("MemAllocSimulator: allocating the rest of memory");
        bl = this.allocMemory(n4 - n7);
        if (!bl && !(bl = this.allocMemory(n2 - n7))) {
            System.out.println("MemAllocSimulator: allocating memory failed");
            return false;
        }
        System.out.println("MemAllocSimulator: Memory allocation succeeded.");
        return true;
    }
}

